# 画面設計書 48-フォームレイアウト（Bootstrap 4 水平）

## 概要

本ドキュメントは、Symfony Twig Bridgeが提供するBootstrap 4対応の水平フォームレイアウトテーマ（bootstrap_4_horizontal_layout.html.twig）の画面設計書である。bootstrap_4_layoutを基盤として、Bootstrap 4のグリッドシステムを利用した水平配置のフォームレンダリングを行う。

### 本画面の処理概要

**業務上の目的・背景**：Bootstrap 4の水平フォームレイアウトは、Bootstrap 4のFlexboxベースのグリッドシステム（col-sm-2 / col-sm-10）を使用してラベルとフィールドを横並びに配置する。Bootstrap 3の水平レイアウトとの主な違いは、form-horizontalクラスの廃止とrowクラスの使用、expanded（展開型選択）要素のfieldset対応などである。

**画面へのアクセス方法**：Symfonyの設定で`twig.form_themes`に`'bootstrap_4_horizontal_layout.html.twig'`を指定する。

**主要な操作・処理内容**：
1. ラベルにcol-form-labelクラスとcol-sm-2グリッドクラスを適用
2. フィールドをcol-sm-10グリッドクラスのdivでラップ
3. フォーム行にform-group rowクラスを適用（Bootstrap 3のform-horizontalからの変更）
4. expanded（展開型）の選択要素はfieldset_form_rowで処理（fieldset/legend構造）
5. label=falseの場合、空のdiv.col-sm-2でスペースを確保
6. submit/reset/checkbox行はラベル列空+フィールド列で配置
7. バリデーションエラー時にis-invalidクラスを行レベルで適用

**画面遷移**：本テーマファイル自体は画面遷移を定義しない。

**権限による表示制御**：テーマファイル自体には権限制御機能はない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 34 | Form | 主機能 | Bootstrap 4対応の水平フォームレイアウトテーマによるフォームレンダリング |
| 36 | Twig Bridge | 主機能 | Twig Bridgeのフォームレンダリング拡張によるBootstrap 4水平用ブロック定義 |

## 画面種別

フォームテーマ（Twigテンプレート断片）

## URL/ルーティング

本テーマファイルは直接URLに紐づかない。

```yaml
twig:
    form_themes: ['bootstrap_4_horizontal_layout.html.twig']
```

## 入出力項目

bootstrap_4_layoutと同一の変数に加え、以下の水平レイアウト固有のブロックを使用する。

| ブロック名 | デフォルト値 | 説明 |
|-----------|-------------|------|
| form_label_class | col-sm-2 | ラベル列のグリッドクラス |
| form_group_class | col-sm-10 | フィールド列のグリッドクラス |

## 表示項目

### オーバーライドされた主要ブロック一覧

| ブロック名 | 説明 | 出力HTML構造 |
|-----------|------|-------------|
| form_label | ラベルにcol-form-labelとcol-sm-2を適用、label=falseで空div | `<label class="col-form-label col-sm-2">` or `<div class="col-sm-2"></div>` |
| form_label_class | ラベル列グリッドクラス | `col-sm-2` |
| form_row | expanded判定し通常行/fieldset行を振り分け | 通常→div.form-group.row、expanded→fieldset_form_row |
| fieldset_form_row | expanded要素用の水平fieldset構造 | `<fieldset><div class="row">label + div.col-sm-10</div></fieldset>` |
| submit_row | 送信ボタンの水平配置 | `<div class="form-group row"><div class="col-sm-2"></div><div class="col-sm-10">button</div></div>` |
| reset_row | リセットボタンの水平配置 | submit_rowと同構造 |
| form_group_class | フィールド列グリッドクラス | `col-sm-10` |
| checkbox_row | チェックボックスの水平配置 | `<div class="form-group row"><div class="col-sm-2"></div><div class="col-sm-10">widget+help</div></div>` |

## イベント仕様

### 1-Bootstrap 4水平レイアウトでのフォームレンダリング

主なHTML出力例：
```html
<!-- 通常フィールド -->
<div class="form-group row">
    <label class="col-form-label col-sm-2" for="form_name">Name</label>
    <div class="col-sm-10">
        <input type="text" class="form-control" id="form_name" />
        <small class="form-text text-muted">Enter your name</small>
    </div>
</div>

<!-- expanded（展開型）選択要素 -->
<fieldset class="form-group">
    <div class="row">
        <legend class="col-form-label col-sm-2">Color</legend>
        <div class="col-sm-10">
            <div class="form-check">...</div>
        </div>
    </div>
</fieldset>

<!-- 送信ボタン -->
<div class="form-group row">
    <div class="col-sm-2"></div>
    <div class="col-sm-10">
        <button type="submit" class="btn-primary btn">Submit</button>
    </div>
</div>
```

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| フォームレンダリング | なし | なし | テンプレートはHTMLレンダリングのみ |

## メッセージ仕様

bootstrap_4_layoutと同一。

## 例外処理

テーマテンプレート自体は例外をスローしない。

## 備考

- `{% use 'bootstrap_4_layout.html.twig' %}`により、bootstrap_4_layoutの全ブロックを基盤として利用
- 4層の継承構造：form_div_layout → bootstrap_base_layout → bootstrap_4_layout → bootstrap_4_horizontal_layout
- Bootstrap 3の水平レイアウトとの主な違い：form-horizontalクラスの廃止、form-group rowクラスの組み合わせ使用
- expanded要素（展開型チェックボックス/ラジオ群）はfieldset_form_rowブロックで処理され、fieldset/legend構造が使用される
- is-invalidクラスはフォーム行レベル（div.form-group.row）にも適用される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | FormView.php | `src/Symfony/Component/Form/FormView.php` | フォームビューの構造を理解する |

#### Step 2: 基盤テーマのチェーンを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | form_div_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/form_div_layout.html.twig` | 最も基盤となるテーマ |
| 2-2 | bootstrap_base_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_base_layout.html.twig` | Bootstrap共通基盤テーマ |
| 2-3 | bootstrap_4_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_4_layout.html.twig` | Bootstrap 4標準テーマ |

#### Step 3: 水平レイアウト固有のオーバーライドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bootstrap_4_horizontal_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_4_horizontal_layout.html.twig` | 水平レイアウト固有のブロック定義を理解する |

**主要処理フロー**:
1. **L1**: `{% use 'bootstrap_4_layout.html.twig' %}` - 基盤テンプレートの読み込み
2. **L5-15**: `form_label` - col-form-labelとcol-sm-2の適用、label=falseで空div
3. **L17-19**: `form_label_class` - col-sm-2
4. **L23-43**: `form_row` - expanded判定、通常行（div.form-group.row）とfieldset行の振り分け
5. **L45-60**: `fieldset_form_row` - expanded要素用のfieldset/legend/div.row構造
6. **L62-69**: `submit_row` - form-group row + 空ラベル列 + フィールド列
7. **L71-78**: `reset_row` - submit_rowと同構造
8. **L80-82**: `form_group_class` - col-sm-10
9. **L84-92**: `checkbox_row` - 水平チェックボックス配置

### プログラム呼び出し階層図

```
{{ form_row(form.field) }}
    |
    +-- form_row [bootstrap_4_horizontal_layout オーバーライド]
            |
            +-- [expanded] fieldset_form_row [bootstrap_4_horizontal_layout]
            |       +-- <fieldset class="form-group">
            |       +-- <div class="row">
            |       +-- form_label → <legend class="col-form-label col-sm-2">
            |       +-- <div class="col-sm-10">widget+help+errors</div>
            |
            +-- [通常] <div class="form-group row">
                    +-- form_label → <label class="col-form-label col-sm-2">
                    +-- <div class="col-sm-10">widget+help</div>
```

### データフロー図

```
[入力]                          [処理]                              [出力]

FormView ---------> TwigRendererEngine ---------> ブロック解決
                    テーマ検索順序:                     |
                    1. bootstrap_4_horizontal           v
                    2. bootstrap_4_layout         Bootstrap 4 水平レイアウトHTML
                    3. bootstrap_base_layout      (<div class="form-group row">,
                    4. form_div_layout             <label class="col-sm-2">,
                                                   <div class="col-sm-10">, ...)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bootstrap_4_horizontal_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_4_horizontal_layout.html.twig` | テンプレート | Bootstrap 4水平フォームテーマ（全93行） |
| bootstrap_4_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_4_layout.html.twig` | テンプレート | Bootstrap 4標準フォームテーマ（全324行） |
| bootstrap_base_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_base_layout.html.twig` | テンプレート | Bootstrap共通基盤テーマ（全209行） |
| form_div_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/form_div_layout.html.twig` | テンプレート | 最も基盤となるフォームレイアウトテーマ（全482行） |
